IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'CP_Cbtes_Rem_Fin') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE CP_Cbtes_Rem_Fin
END
GO

CREATE PROCEDURE [dbo].[CP_Cbtes_Rem_Fin]		@pId_Trans				INT
AS 
SET NOCOUNT ON


/*Declaracion Variables Locales*/
DECLARE @Id_Cta_Contable		INT
DECLARE @Fecha					DATETIME
DECLARE @Observacion			VARCHAR(100)
DECLARE @Item					SMALLINT

DECLARE @Descripcion_Cbte		VARCHAR(80)
DECLARE @Imp_Gravado_Sum_It		DECIMAL(20,2)
DECLARE @Porc_Bonificacion_Cb	DECIMAL(5,2)
DECLARE @Imp_Gravado			DECIMAL(20,2)
DECLARE @Imp_Iva_Sum_It			DECIMAL(20,2)
DECLARE @Imp_Iva				DECIMAL(20,2)
DECLARE @Imp_Total				DECIMAL(20,2)
DECLARE @Saldo					DECIMAL(20,2)
DECLARE @Imp_Bonificacion		DECIMAL(20,2)
DECLARE @Cantidad				DECIMAL(12, 4)

DECLARE @Mensaje			VARCHAR(100)
/*Fin de Declaraciones Variables Locales */

PRINT 'Procedimiento: CP_Cbtes_Rem_Fin'



DECLARE @Trans TABLE (ErrorNumber	INT 
					,ErrorSeverity  INT 
					,ErrorState		INT
					,ErrorProcedure	VARCHAR(100)
					,ErrorLine		INT
					,ErrorMessage	VARCHAR(1000)
					,Id_Trans		INT)

DECLARE @Trans2 TABLE (ErrorNumber	INT 
					,ErrorSeverity  INT 
					,ErrorState		INT
					,ErrorProcedure	VARCHAR(100)
					,ErrorLine		INT
					,ErrorMessage	VARCHAR(1000)
					)


INSERT INTO @Trans2
	EXEC dbo.CP_Cbtes_Grabar_Numero @pId_Trans

	
IF (SELECT TOP 1 ErrorNumber FROM @Trans) <> 0
BEGIN
	SELECT * FROM @Trans2
	RETURN
END

BEGIN TRY
--	BEGIN TRAN
		
	SET @Descripcion_Cbte = (dbo.CF_Cbte_Descrip(@pId_Trans))
	
	UPDATE Transacciones SET Descripcion = SUBSTRING((Descripcion + ' ' + @Descripcion_Cbte), 1, 50) WHERE Id_Trans = @pId_Trans
	UPDATE Cbtes_Items SET Id_Estado_Cbte = 1/*PENDIENTE*/ WHERE Id_Trans = @pId_Trans

	SET @Porc_Bonificacion_Cb	= ISNULL((SELECT ISNULL(Porc_Bonificacion, 0) FROM Cbtes WHERE Id_Trans = @pId_Trans), 0)
	SET @Imp_Gravado_Sum_It		= ISNULL((SELECT SUM((ISNULL(Imp_Gravado, 0) * ISNULL(Cantidad_Saldo, 0))) FROM Cbtes_Items WHERE Id_Trans = @pId_Trans), 0)

	IF(@Porc_Bonificacion_Cb = 0)
	BEGIN
		SET @Imp_Gravado = @Imp_Gravado_Sum_It
	END
	ELSE
	BEGIN
		SET @Imp_Gravado = (@Imp_Gravado_Sum_It * ((100 - @Porc_Bonificacion_Cb) / 100))
	END

	SET @Imp_Iva_Sum_It			= ISNULL((SELECT SUM(ISNULL(Imp_Iva, 0)) FROM Cbtes_Items WHERE Id_Trans = @pId_Trans), 0)
	SET @Imp_Iva				= @Imp_Iva_Sum_It

	SET @Imp_Total			= @Imp_Gravado + @Imp_Iva
	SET @Saldo				= @Imp_Total

	SET @Imp_Bonificacion	= (@Imp_Gravado_Sum_It - @Imp_Gravado)		

	SET @Cantidad			= ISNULL((SELECT COUNT(*) FROM Cbtes_Items WHERE Id_Trans = @pId_Trans), 0)


	UPDATE Cbtes 
	SET 
	Id_Estado_Cbte		= 1/*PENDIENTE*/, 
	Cantidad			= @Cantidad,
	Imp_Gravado			= @Imp_Gravado, 
	Saldo				= @Saldo, 
	Imp_Iva				= @Imp_Iva,
	Imp_Bonificacion	= @Imp_Bonificacion,
	Imp_Total			= @Imp_Total
	WHERE 
	Id_Trans = @pId_Trans	
	
--	COMMIT

	SET @Mensaje = @Descripcion_Cbte

	SELECT	 0				AS ErrorNumber 
			,0				AS ErrorSeverity  
			,0				AS ErrorState 
			,0				AS ErrorProcedure  
			,0				AS ErrorLine		
			,@Mensaje		AS ErrorMessage
			,@pId_Trans		AS Id_Trans
    RETURN 0
	
END TRY  


BEGIN CATCH  
    SELECT  
		ERROR_NUMBER() AS ErrorNumber  
		,ERROR_SEVERITY() AS ErrorSeverity  
		,ERROR_STATE() AS ErrorState  
		,ERROR_PROCEDURE() AS ErrorProcedure  
		,ERROR_LINE() AS ErrorLine  
		,ERROR_MESSAGE() AS ErrorMessage
		,@pId_Trans		AS Id_Trans
	    
--	ROLLBACK
END CATCH

PRINT 'FIN Procedimiento: CP_Cbtes_Rem_Fin'

